#property copyright "Copyright  2008, FOREXflash Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_chart_window
#property indicator_buffers 7
#property indicator_color1 Black
#property indicator_color2 Black
#property indicator_color3 Black
#property indicator_color4 Black
#property indicator_color5 Black
#property indicator_color6 Black
#property indicator_color7 Black

extern int MA_Length = 100;
extern int ShiftUpText = 0;
extern int ShiftDownText = 0;
extern int SizeText = 7;
extern int AngleText = 90;
extern int Corner = 4;
int gi_100 = 500;
double g_ibuf_104[];
double g_ibuf_108[];
double g_ibuf_112[];
double g_ibuf_116[];
double g_ibuf_120[];
string gs_unused_124;
int gi_132 = 1;
double gd_136;
double gd_144;

int init() {
  
   SetIndexBuffer(0, g_ibuf_104);
   SetIndexStyle(0, DRAW_NONE);
   SetIndexBuffer(1, g_ibuf_108);
   SetIndexStyle(1, DRAW_NONE);
   SetIndexBuffer(2, g_ibuf_112);
   SetIndexStyle(2, DRAW_NONE);
   SetIndexBuffer(5, g_ibuf_116);
   SetIndexStyle(5, DRAW_NONE);
   SetIndexBuffer(6, g_ibuf_120);
   SetIndexStyle(6, DRAW_NONE);
   string ls_12 = "VSA BAR TEXT SIGNALS";
   IndicatorShortName(ls_12);
   gs_unused_124 = ls_12;
   IndicatorDigits(1);
   gd_136 = ShiftUpText * Point;
   gd_144 = ShiftDownText * Point;
   return (1);
}

int deinit() {
   datetime l_time_0;
   string l_name_4;
   for (int l_index_12 = 0; l_index_12 < Bars; l_index_12++) {
      l_time_0 = Time[l_index_12];
      l_name_4 = "NDS_" + l_time_0;
      if (ObjectFind(l_name_4) >= 0) ObjectDelete(l_name_4);
      l_name_4 = "Suppl_" + l_time_0;
      if (ObjectFind(l_name_4) >= 0) ObjectDelete(l_name_4);
   }
   ObjectsDeleteAll(0, OBJ_LABEL);
   return (0);
}

int start() {
   
   AVGSpread();
   AVGVolume();
   return (0);
}

int AVGSpread() {
   int li_8 = IndicatorCounted();
   if (li_8 > 0) li_8--;
   int li_4 = Bars - li_8;
   for (int li_0 = 0; li_0 < li_4; li_0++) g_ibuf_108[li_0] = (iHigh(NULL, 0, li_0) - iLow(NULL, 0, li_0)) / Point / gi_132;
   for (li_0 = 0; li_0 < li_4; li_0++) g_ibuf_112[li_0] = iMAOnArray(g_ibuf_108, 0, MA_Length, 0, MODE_EMA, li_0);
   return (0);
}

int AVGVolume() {
   double ld_0;
   double ld_24;
   double ld_32;
   double ld_40;
   double ld_48;
   double ld_56;
   int li_12 = IndicatorCounted();
   if (li_12 > 0) li_12--;
   if (gi_100 == 0) gi_100 = Bars - li_12;
   int li_8 = gi_100;
   for (int li_16 = 0; li_16 < li_8; li_16++) {
      ld_0 = 0;
      for (int li_20 = li_16; li_20 < li_16 + MA_Length; li_20++) ld_0 = Volume[li_20] + ld_0;
      g_ibuf_116[li_16] = NormalizeDouble(ld_0 / MA_Length, 0);
      g_ibuf_120[li_16] = iVolume(NULL, 0, li_16);
      ld_24 = (High[li_16 + 1] + (Low[li_16 + 1])) / 2.0;
      ld_32 = (High[li_16 + 1] + (Low[li_16 + 1])) / 2.0 + (High[li_16 + 1] - (Low[li_16 + 1])) / 3.6;
      ld_40 = (High[li_16 + 1] + (Low[li_16 + 1])) / 2.0 - (High[li_16 + 1] - (Low[li_16 + 1])) / 3.6;
      if (High[li_16 + 1] > High[li_16 + 2] && g_ibuf_108[li_16 + 1] > 1.8 * (g_ibuf_112[li_16 + 1]) && Close[li_16 + 1] < ld_40 && g_ibuf_120[li_16 + 1] > g_ibuf_120[li_16 +
         2] && g_ibuf_120[li_16 + 1] > g_ibuf_116[li_16 + 1] && g_ibuf_120[li_16 + 1] > g_ibuf_116[li_16 + 1]) TextOutput(li_16, High[li_16 + 1] + gd_136, 1, li_16 + 1);
      if (High[li_16 + 1] > High[li_16 + 2] && g_ibuf_108[li_16 + 1] > 1.8 * (g_ibuf_112[li_16 + 1]) && Close[li_16 + 1] < ld_40 && g_ibuf_120[li_16 + 1] > g_ibuf_120[li_16 +
         2] && g_ibuf_120[li_16 + 1] > 2.0 * (g_ibuf_116[li_16 + 1])) TextOutput(li_16, High[li_16 + 1] + gd_136, 2, li_16 + 1);
      if (High[li_16 + 1] > High[li_16 + 2] && g_ibuf_108[li_16 + 1] > 1.8 * (g_ibuf_112[li_16 + 1]) && Close[li_16 + 1] > ld_40 && Close[li_16 + 1] < ld_32 && g_ibuf_120[li_16 +
         1] > g_ibuf_120[li_16 + 2] && g_ibuf_120[li_16 + 1] > g_ibuf_116[li_16 + 1]) TextOutput(li_16, High[li_16 + 1] + gd_136, 3, li_16 + 1);
      if (High[li_16 + 1] > High[li_16 + 2] && g_ibuf_108[li_16 + 1] < g_ibuf_112[li_16 + 1] && Close[li_16 + 1] < ld_40 && g_ibuf_120[li_16 + 1] > g_ibuf_120[li_16 + 2] &&
         g_ibuf_120[li_16 + 1] < g_ibuf_116[li_16 + 1]) TextOutput(li_16, High[li_16 + 1] + gd_136, 4, li_16 + 1);
      if (Close[li_16 + 1] > Close[li_16 + 2] && Close[li_16 + 1] < ld_24 && g_ibuf_108[li_16 + 1] < 0.8 * (g_ibuf_112[li_16 + 1]) && g_ibuf_120[li_16 + 1] < g_ibuf_116[li_16 +
         1]) TextOutput(li_16, High[li_16 + 1] + gd_136, 5, li_16 + 1);
      if (Close[li_16 + 1] > Close[li_16 + 2] && Close[li_16 + 1] > ld_32 && g_ibuf_108[li_16 + 1] > 1.5 * (g_ibuf_112[li_16 + 1]) && g_ibuf_120[li_16 + 1] > g_ibuf_120[li_16 +
         2]) TextOutput(li_16, High[li_16 + 1] + gd_136, 6, li_16 + 1);
      if (Close[li_16 + 1] > Close[li_16 + 2] && Close[li_16 + 1] < ld_24 && g_ibuf_108[li_16 + 1] > 1.5 * (g_ibuf_112[li_16 + 1]) && g_ibuf_120[li_16 + 1] > g_ibuf_120[li_16 +
         2] && g_ibuf_120[li_16 + 1] > g_ibuf_116[li_16 + 1]) TextOutput(li_16, Low[li_16 + 1] - gd_136, 7, li_16 + 1);
      if (Close[li_16 + 1] < Close[li_16 + 2] && Close[li_16 + 1] > ld_32 && g_ibuf_120[li_16 + 1] < g_ibuf_120[li_16 + 2] && g_ibuf_120[li_16 + 1] < g_ibuf_116[li_16 +
         1]) TextOutput(li_16, Low[li_16 + 1] - gd_136, 8, li_16 + 1);
      if (Close[li_16 + 1] < Close[li_16 + 2] && Close[li_16 + 1] > ld_24 && g_ibuf_120[li_16 + 1] > g_ibuf_116[li_16 + 1]) TextOutput(li_16, Low[li_16 + 1] - gd_136, 9, li_16 + 1);
      if (Close[li_16 + 1] > Close[li_16 + 2] && Close[li_16 + 1] > ld_24 && Low[li_16 + 1] < Low[li_16 + 2] && Low[li_16 + 2] < Low[li_16 + 3] && g_ibuf_108[li_16 + 1] > 1.5 * (g_ibuf_112[li_16 +
         1]) && g_ibuf_120[li_16 + 1] > g_ibuf_116[li_16 + 1]) TextOutput(li_16, Low[li_16 + 1] - gd_136, 10, li_16 + 1);
      if (Close[li_16 + 1] < Close[li_16 + 2] && Close[li_16 + 1] < ld_24 && g_ibuf_108[li_16 + 1] < 0.8 * (g_ibuf_112[li_16 + 1]) && g_ibuf_120[1] < g_ibuf_116[1]) TextOutput(li_16, Low[li_16 + 1] - gd_136, 11, li_16 + 1);
      if (ObjectFind("001Vol") == -1) {
         ObjectCreate("001Vol", OBJ_LABEL, 0, 0, 0);
         ObjectSet("001Vol", OBJPROP_COLOR, Red);
         ObjectSet("001Vol", OBJPROP_CORNER, Corner);
         ObjectSet("001Vol", OBJPROP_XDISTANCE, 5);
         ObjectSet("001Vol", OBJPROP_YDISTANCE, 15);
      }
      ObjectSetText("001Vol", "VOLUME: PENDING...", 10, "Tahoma Bold", White);
      if (g_ibuf_120[1] < g_ibuf_116[1] / 2.0) ObjectSetText("001Vol", "VOLUME: VERY LOW ", 10, "Tahoma Bold", Red);
      if (g_ibuf_120[1] < g_ibuf_116[1] && g_ibuf_120[1] > g_ibuf_116[1] / 2.0) ObjectSetText("001Vol", "VOLUME: LOW ", 10, "Tahoma Bold", Red);
      if (g_ibuf_120[1] > 2.0 * g_ibuf_116[1]) ObjectSetText("001Vol", "VOLUME: VERY HIGH", 10, "Tahoma Bold", Lime);
      if (g_ibuf_120[1] > g_ibuf_116[1] && g_ibuf_120[1] < 2.0 * g_ibuf_116[1]) ObjectSetText("001Vol", "VOLUME: HIGH", 10, "Tahoma Bold", Lime);
      if (ObjectFind("002") == -1) {
         ObjectCreate("002", OBJ_LABEL, 0, 0, 0);
         ObjectSet("002", OBJPROP_COLOR, Red);
         ObjectSet("002", OBJPROP_CORNER, Corner);
         ObjectSet("002", OBJPROP_XDISTANCE, 160);
         ObjectSet("002", OBJPROP_YDISTANCE, 15);
      }
      ObjectSetText("002", "SPREAD: NORMAL", 10, "Tahoma Bold", White);
      if (g_ibuf_108[1] > 1.8 * g_ibuf_112[1]) ObjectSetText("002", "SPREAD: WIDE", 10, "Tahoma Bold", Lime);
      if (g_ibuf_108[1] < 0.8 * g_ibuf_112[1]) ObjectSetText("002", "SPREAD: NARROW", 10, "Tahoma Bold", Red);
      if (ObjectFind("003") == -1) {
         ObjectCreate("003", OBJ_LABEL, 0, 0, 0);
         ObjectSet("003", OBJPROP_COLOR, Red);
         ObjectSet("003", OBJPROP_CORNER, Corner);
         ObjectSet("003", OBJPROP_XDISTANCE, 310);
         ObjectSet("003", OBJPROP_YDISTANCE, 15);
      }
      ObjectSetText("003", "BAR POS:PENDING..", 10, "Tahoma Bold", White);
      if (Close[1] > Close[2]) ObjectSetText("003", "BAR POS: UP BAR", 10, "Tahoma Bold", Lime);
      if (Close[1] < Close[2]) ObjectSetText("003", "BAR POS: DOWN BAR", 10, "Tahoma Bold", Red);
      ld_48 = (High[1] + Low[1]) / 2.0 + (High[1] - Low[1]) / 3.6;
      ld_56 = (High[1] + Low[1]) / 2.0 - (High[1] - Low[1]) / 3.6;
      if (ObjectFind("004") == -1) {
         ObjectCreate("004", OBJ_LABEL, 0, 0, 0);
         ObjectSet("004", OBJPROP_COLOR, Red);
         ObjectSet("004", OBJPROP_CORNER, Corner);
         ObjectSet("004", OBJPROP_XDISTANCE, 470);
         ObjectSet("004", OBJPROP_YDISTANCE, 15);
      }
      ObjectSetText("004", "BAR CLOSE: MIDCLOSE", 10, "Tahoma Bold", White);
      if (Close[1] > ld_48) ObjectSetText("004", "BAR CLOSE: UP CLOSE", 10, "Tahoma Bold", Lime);
      if (Close[1] < ld_56) ObjectSetText("004", "BAR CLOSE: DOWN CLOSE", 10, "Tahoma Bold", Red);
   }
   return (0);
}

void TextOutput(int ai_0, double a_price_4, int ai_12, int ai_16) {
   string l_text_32;
   int l_time_20 = Time[ai_0 + 1];
   string l_name_24 = "NDS_" + l_time_20;
   if (ObjectFind(l_name_24) >= 0) ObjectDelete(l_name_24);
   ObjectCreate(l_name_24, OBJ_TEXT, 0, l_time_20, a_price_4);
   ObjectSet(l_name_24, OBJPROP_ANGLE, AngleText);
   if (ai_12 == 1) {
      l_text_32 = "UPTHRUST / Weakness_" + ai_16;
      ObjectSetText(l_name_24, l_text_32, SizeText, "Tahoma", White);
   }
   if (ai_12 == 2) {
      l_text_32 = "HV UPTHRUST / Weakness_" + ai_16;
      ObjectSetText(l_name_24, l_text_32, SizeText, "Tahoma", White);
   }
   if (ai_12 == 3) {
      l_text_32 = "LOW UPTHRUST / Demand stronger_" + ai_16;
      ObjectSetText(l_name_24, l_text_32, SizeText, "Tahoma", White);
   }
   if (ai_12 == 4) {
      l_text_32 = "PSEUDO UPTHRUST / Weakness_" + ai_16;
      ObjectSetText(l_name_24, l_text_32, SizeText, "Tahoma", White);
   }
   if (ai_12 == 5) {
      l_text_32 = "NO DEMAND / Weakness_" + ai_16;
      ObjectSetText(l_name_24, l_text_32, SizeText, "Tahoma", White);
   }
   if (ai_12 == 6) {
      l_text_32 = "MARK UP / Strenght_" + ai_16;
      ObjectSetText(l_name_24, l_text_32, SizeText, "Tahoma", White);
   }
   if (ai_12 == 7) {
      l_text_32 = "FAILED MARK UP / Weakness_" + ai_16;
      ObjectSetText(l_name_24, l_text_32, SizeText, "Tahoma", White);
   }
   if (ai_12 == 8) {
      l_text_32 = "TESTING FOR SUPPLY / Strenght_" + ai_16;
      ObjectSetText(l_name_24, l_text_32, SizeText, "Tahoma", White);
   }
   if (ai_12 == 9) {
      l_text_32 = "STOPPING VOLUME / Strenght_" + ai_16;
      ObjectSetText(l_name_24, l_text_32, SizeText, "Tahoma", White);
   }
   if (ai_12 == 10) {
      l_text_32 = "REVERSE UPTHRUST / Strenght_" + ai_16;
      ObjectSetText(l_name_24, l_text_32, SizeText, "Tahoma", White);
   }
   if (ai_12 == 11) {
      l_text_32 = "NO SUPPLY / Strenght_" + ai_16;
      ObjectSetText(l_name_24, l_text_32, SizeText, "Tahoma", White);
   }
}